(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     82847,       1841]
NotebookOptionsPosition[     81894,       1817]
NotebookOutlinePosition[     82337,       1834]
CellTagsIndexPosition[     82294,       1831]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   StyleBox[
    RowBox[{
     RowBox[{
      FormBox[
       RowBox[{
        StyleBox[" ",
         FontFamily->"Times",
         FontWeight->"Bold",
         FontSlant->"Plain"], 
        RowBox[{
         SubscriptBox[
          StyleBox["\[ScriptCapitalS]",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Plain"], 
          StyleBox["m",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Italic"]], 
         SubscriptBox[
          StyleBox["\[ScriptCapitalB]",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Plain"], 
          StyleBox["n",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Italic"]]}]}],
       TraditionalForm], " ", "partitioned", " ", "Polytope", " ", 
      "Formalism"}], " ", "\[IndentingNewLine]", 
     RowBox[{
     "of", " ", "constitutional", " ", "isomerism", " ", "motions", " ", 
      "order", " ", "tabulation"}]}],
    FontSize->24], 
   StyleBox[" ",
    FontSize->24], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "input", " ", "directory", " ", "location", " ", "of", " ", "the", " ", 
    "species", " ", 
    RowBox[{"file", ".", " ", "Outputs"}], " ", "will", " ", "be", " ", 
    "save", " ", "here"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dir", "=", "\"\<...your directory path...\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{"Enter", " ", "the", " ", 
      RowBox[{"species_SmBn", ".", "txt"}], " ", "file", " ", "name", " ", 
      "here"}], "*)"}],
    FontSize->18,
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"file", "=", "\"\<species_D3h_S3B2.txt\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"after", " ", "setting", " ", "the", " ", "above"}], ",", " ", 
      RowBox[{"press", " ", "<", "SHIFT", ">", 
       RowBox[{"+", 
        RowBox[{"<", "ENTER", ">"}]}]}]}], " ", "*)"}],
    FontSize->18,
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"set", " ", "directory"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "dir", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"open", " ", "the", " ", "specified", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", 
     RowBox[{"OpenRead", "[", "file", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"read", " ", "the", " ", 
     SubscriptBox["S", "m"], 
     SubscriptBox["B", "n"], " ", "class", " ", "from", " ", "the", " ", 
     "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"class", "=", 
     RowBox[{"ReadLine", "[", "str", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "read", " ", "the", " ", "site", " ", "symmetry", " ", "point", " ", 
     "group", " ", "from", " ", "the", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pg", "=", 
     RowBox[{
      RowBox[{"StringSplit", "[", 
       RowBox[{"ReadLine", "[", "str", "]"}], "]"}], "\[LeftDoubleBracket]", 
      "1", "\[RightDoubleBracket]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"generate", " ", "the", " ", "site", " ", "indices", "  ", "0"}],
      ",", 
     RowBox[{"...", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fullset", "=", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"Length", "[", "locants", "]"}], "-", "1"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"extract", " ", "number", " ", "of", " ", "bonders"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bonders", "=", 
     RowBox[{"ToExpression", "[", 
      RowBox[{"StringTake", "[", 
       RowBox[{"class", ",", 
        RowBox[{"-", 
         RowBox[{"ToExpression", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"StringLength", "[", "class", "]"}], "-", 
            RowBox[{"Flatten", "[", 
             RowBox[{"StringPosition", "[", 
              RowBox[{"class", ",", "\"\<B\>\""}], "]"}], "]"}]}], "//", 
           "Last"}], "]"}]}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "number", " ", "of", " ", "genera", " ", "in", " ", "each", " ", "family",
      " ", "read", " ", "out", " ", "from", " ", "the", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ngenera", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"StringTake", "[", 
         RowBox[{"#", ",", 
          RowBox[{"-", "5"}]}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"FindList", "[", 
       RowBox[{"file", ",", "\"\<Nber of genera for this family\>\""}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "count", " ", "out", " ", "the", " ", "number", " ", "of", " ", "species",
      " ", "from", " ", "the", " ", "file"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"Nspecies", "=", 
     RowBox[{
      RowBox[{"Differences", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"StringSplit", "[", 
             RowBox[{"FindList", "[", 
              RowBox[{"file", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<:\>\"", ",", "\"\<#\>\""}], "}"}]}], "]"}], 
             "]"}], ",", "\"\<family=\>\""}], "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"FindList", "[", 
             RowBox[{"file", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<:\>\"", ",", "\"\<#\>\""}], "}"}]}], "]"}], "]"}],
            "+", "1"}], "}"}]}], "]"}], "]"}], "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "count", " ", "out", " ", "the", " ", "number", " ", "of", " ", "genera", 
     " ", "from", " ", "the", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "read", " ", "in", " ", "from", " ", "the", " ", "file", " ", "each", " ",
      "species", " ", "index", " ", "designation", " ", "within", " ", "each",
      " ", "genus"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GenSpecies", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"StringTrim", "[", 
        RowBox[{"StringDrop", "[", 
         RowBox[{"#", ",", "8"}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"FoldPairList", "[", 
       RowBox[{"TakeDrop", ",", 
        RowBox[{"FindList", "[", 
         RowBox[{"file", ",", "\"\<: \>\""}], "]"}], ",", "Nspecies"}], 
       "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"GenSpecies", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"StringSplit", "[", 
        RowBox[{"#", ",", "\"\<:\>\""}], "]"}], "&"}], "/@", "GenSpecies"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "convert", " ", "species", " ", "index", " ", "designations", " ", "into",
      " ", "individual", " ", "bonder", " ", "sets"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Species", "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"interp", "[", 
         RowBox[{"#", ",", "fullset"}], "]"}], "&"}], ",", "GenSpecies", ",", 
       RowBox[{"{", "3", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "converts", " ", "a", " ", "single", " ", "bonder", " ", "configuration", 
     " ", "string", " ", "into", " ", "a", " ", "numerical", " ", 
     RowBox[{"set", ".", " ", "Handles"}], " ", "set", " ", "complement", " ",
      "notation"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"interp", "[", "a_", "]"}], ":=", 
    RowBox[{"ToExpression", "[", 
     RowBox[{"\"\<{\>\"", "<>", "a", "<>", "\"\<}\>\""}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"interp", "[", 
     RowBox[{"a_", ",", "set_"}], "]"}], ":=", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringTake", "[", 
        RowBox[{"a", ",", "1"}], "]"}], "==", "\"\<\\\\\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Complement", "[", 
       RowBox[{"set", ",", 
        RowBox[{"interp", "[", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"a", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"interp", "[", "a", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "test", " ", "to", " ", "see", " ", "if", " ", "all", " ", "pairwise", " ",
      "bonder", " ", "configurations", " ", "have", " ", "subset", " ", 
     "relationships"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OnlySubsetPairsQ", "[", 
     RowBox[{"s1_", ",", "s2_", ",", "1"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"SubsetQ", "[", 
      RowBox[{
       RowBox[{"s1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"s2", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[Or]", 
     RowBox[{"SubsetQ", "[", 
      RowBox[{
       RowBox[{"s2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"s1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OnlySubsetPairsQ", "[", 
     RowBox[{"s1_", ",", "s2_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"And", "[", 
     RowBox[{
      RowBox[{"OnlySubsetPairsQ", "[", 
       RowBox[{
        RowBox[{"Rest", "[", "s1", "]"}], ",", 
        RowBox[{"Rest", "[", "s2", "]"}], ",", 
        RowBox[{"b", "-", "1"}]}], "]"}], ",", 
      RowBox[{"OnlySubsetPairsQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"s1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"s2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", "1"}], "]"}]}], "]"}]}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "compares", " ", "two", " ", "configurations", " ", "to", " ", 
     "determine", " ", "the", " ", "\"\<motions order\>\""}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"comp", "[", 
     RowBox[{"s1_", ",", "s2_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"OnlySubsetPairsQ", "[", 
       RowBox[{"s1", ",", "s2", ",", "b"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Total", "[", 
       RowBox[{"Length", "/@", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"SubsetQ", "[", 
             RowBox[{
              RowBox[{"s1", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"s2", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"s1", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"s2", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"SubsetQ", "[", 
               RowBox[{
                RowBox[{"s2", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"s1", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"Complement", "[", 
               RowBox[{
                RowBox[{"s2", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"s1", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
              "\[IndentingNewLine]", "\"\<-\>\""}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "bonders"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\"\<-\>\""}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"format", "[", 
     RowBox[{"sp_", ",", "locantmap_"}], "]"}], ":=", 
    RowBox[{"StringTrim", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringJoin", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"#", "/.", "locantmap"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\< \>\"", "->", "\"\<\>\""}], ",", 
              RowBox[{"\"\<{\>\"", "->", "\"\<\>\""}], ",", 
              RowBox[{"\"\<}\>\"", "->", "\"\<\>\""}]}], "}"}]}], "]"}], 
          "<>", "\"\<:\>\""}], "&"}], "/@", "sp"}], "]"}], ",", "\"\<:\>\""}],
      "]"}]}], "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Species", ",", "1"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"locantmap", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"i", "->", 
        RowBox[{"ToString", "[", "i", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Max", "[", "s", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ticks", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"format", "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "locantmap"}], "]"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "s", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Rotate", "[", 
            RowBox[{
             RowBox[{"format", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", "locantmap"}], "]"}], ",",
              " ", 
             RowBox[{"90", " ", "Degree"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "s", "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mo", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"comp", "[", 
        RowBox[{
         RowBox[{"s", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"s", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", "bonders"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "s", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "[", "s", "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plot", "=", 
    RowBox[{"MatrixPlot", "[", 
     RowBox[{"mo", ",", 
      RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
      RowBox[{"ColorRules", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<-\>\"", "->", "Black"}], "}"}]}], ",", 
      RowBox[{"FrameTicks", "->", "ticks"}], ",", 
      RowBox[{"FrameTicksStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"FontFamily", "\[Rule]", "\"\<Consolas\>\""}], ",", "Black", 
         ",", "8"}], "]"}]}], ",", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{"Automatic", ",", "Above"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "->", 
       RowBox[{"10", 
        RowBox[{"Length", "[", "s", "]"}]}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"table", "=", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"TableForm", "[", 
       RowBox[{"mo", ",", 
        RowBox[{"TableHeadings", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"format", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", "locantmap"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "s", "]"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Rotate", "[", 
              RowBox[{
               RowBox[{"format", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", "locantmap"}], "]"}], ",",
                " ", 
               RowBox[{"90", " ", "Degree"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "s", "]"}]}], "}"}]}], "]"}]}], 
          "}"}]}]}], "]"}], ",", "8", ",", "Black"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9366038141356306`*^9, 3.9366038498172455`*^9}, {
   3.936604000492346*^9, 3.9366040033566656`*^9}, {3.9366042774478655`*^9, 
   3.936604312338824*^9}, {3.936604413474033*^9, 3.936604516276634*^9}, {
   3.9366045475103397`*^9, 3.936604563019639*^9}, {3.9366046024974666`*^9, 
   3.9366046619102716`*^9}, 3.9366047082519746`*^9, {3.936604770468463*^9, 
   3.936604805991053*^9}, {3.936604838080928*^9, 3.9366048604626136`*^9}, {
   3.936604968354729*^9, 3.9366049752711544`*^9}, {3.936605539513155*^9, 
   3.9366055564378796`*^9}, {3.9366056092256575`*^9, 3.936605613083494*^9}, {
   3.9366412853002424`*^9, 3.9366413224363995`*^9}, {3.9366413644152174`*^9, 
   3.936641409834057*^9}, {3.936641477191253*^9, 3.9366414773126574`*^9}, {
   3.9366417453696194`*^9, 3.936641745472734*^9}, {3.9366419024968185`*^9, 
   3.936641918371439*^9}, {3.9366419656320567`*^9, 3.936642042698775*^9}, {
   3.9366424763905945`*^9, 3.9366424865955577`*^9}, {3.936642810451953*^9, 
   3.936642811728853*^9}, {3.9366429232926435`*^9, 3.9366429415734386`*^9}, {
   3.9366431003584003`*^9, 3.9366431022140684`*^9}, {3.9366431965959544`*^9, 
   3.9366432074190865`*^9}, {3.9366432414165897`*^9, 
   3.9366432474645524`*^9}, {3.9366433800219307`*^9, 
   3.9366434274617586`*^9}, {3.936643546357256*^9, 3.9366435874721513`*^9}, 
   3.936643908144305*^9, {3.9366439462965326`*^9, 3.936643958075059*^9}, {
   3.9366440331804113`*^9, 3.936644084785348*^9}, {3.936644120563137*^9, 
   3.93664413383276*^9}, {3.9366442202565255`*^9, 3.9366442417679157`*^9}, {
   3.9366442833741803`*^9, 3.9366443550541344`*^9}, {3.936644418227792*^9, 
   3.936644418384387*^9}, {3.9366444552914357`*^9, 3.936644459469926*^9}, 
   3.936644502331868*^9, {3.936644578366435*^9, 3.9366445813148317`*^9}, {
   3.936644625560277*^9, 3.9366446374343452`*^9}, {3.936645119760058*^9, 
   3.9366451525520544`*^9}, {3.936645234477062*^9, 3.9366452512116776`*^9}, {
   3.9366453165456343`*^9, 3.9366453215096498`*^9}, {3.9366454329074345`*^9, 
   3.93664547958759*^9}, {3.936697658158586*^9, 3.936697671593373*^9}, {
   3.9366977083485875`*^9, 3.9366977356592817`*^9}, {3.936697794176509*^9, 
   3.936697794308673*^9}, {3.97163515480785*^9, 
   3.9716351613801975`*^9}},ExpressionUUID->"74b5ceff-56d8-40b3-b4d0-\
cbb72a96ec14"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    RasterBox[CompressedData["
1:eJztXT1oFkEUDIh20UbslUgKERW1DIcWamUhFoLYaCwsJKSxMSKSWkSsUppO
bAVRQQMWphARLBSJIPgTkqgIimAhEYntC4zOy5u5u4FAOJbZd/ftzc2+/dt6
euzY2XUDAwN7/v79+X/x6cjQxNhSMz01/HLz7EzzZHR8+frCTON+fWTj5M8d
7z81mz6fWf9o8E3z7d2unYs3ZvvrotcvT/5YfHdzqflyavLh9wsfmudTd27d
P/ysv06+/vXX4Ovb1z42r+6d23v08Xyz/+7BE1e3vyi7Pvdgw6WF82+bA0e2
7L5ycr45/uHioW375uD2MxBAjSdC9Huh5VEeFn9VvSgPGg+KqJ2r8UTtNrt8
FGf27xuVj/QHva9sPWHpDPr9ZT1/lKfXQy5YeoLyo/VW6U+VXkX6g/q37PtV
81Fde9/d9ZmlA2j8LJ4q/Yn4q/QHfc5q/azsfAUaj7v/YZVnxZOtSyhPle/K
1h/W95qlP6hfQp+Dmv+p0iVWeVY8aj4Q5anSh2yeKv1B/VK2/mQ/z6q8U3be
20V/su+Lxa/mi1Ce7Hqr8uFV+pP9ParyIShPdt4sAstXo0DbLYufFY9af5nF
E81jyS6Pjr+7jA9m86D8rHqz36/seCK46CFr/lIUj1o/NyqfrT9RebXxwSqf
FpXP5unf97UZV63y4S4+qkp/Iv62jg9G5VGeqvkwXfM/auM+EbqWT8vWH5Zf
ivjVfDIKNR/VtfedFQ+LH+XJ1odsnir9icq7jA+q6QarXpd8b5+fX5t5sCx9
Q+ut0p+q/h3LL6G/Y1SexZOtny7j0VXj3Shc4sxGpD9R+SqdVJtHoZb3ztY9
tefvwq9WrxpY+oOWV5vfyOJRyy+p9R/d1zuw4BJnNlD9ieAybwEFq527PAe1
8btsnen9Ty1Y+hNBLT+PIrudu+iG2vx2l/e3j3N1ZOtPBJd5C1U+X003qvJR
7v0sFF3zY1X6g6LKR6l9r13mgfRYQVX/0UWf26o/7u8R2q7UfAuKrv1e1fH+
L1j366I/EdTmpaP82e1Wzf+464wa3P2Vu/6wkO2v1L6PauPpLGTn+VlwWe+T
HQ+qP2r5EBQu64mq+pXZ6xdQnqp6Xd5fF/4I2fs/s8pXoWo9kVq/CX0O7vqT
DTU9qYqH1f9y+d0juJxToDa/Wk2X3NthhLbqFcv/RHBpD+7nFKjNP8ze1yKC
S3trq56g/C75Z5d2q7a/DQusfFS2LrnoD4q26lW2/8mGS7tV298GRXY+Si3v
raZjLu9jhGz/09b17GpwP98h+34juPhnFlz0qsr/qK1njKDWrlBU7Vub3X6y
895qv7uLnkRw9z/ZcBkvVjvfIULVfOmq8bher/4N7v6HFU8EtXbF0iu18x1Y
/FV572yoxcl6f93338jmd+/fuZzvECE7H+WuSxHU4kf1R82/qemVS38N5VE7
3yFCdj5KbV6E2j54/fj76nCPHwVrfavaeTdR+ar1KWq6FMFlX4Wq/LMa3OOv
yqNW5cOrvtfZ85ciqOXJu+Z/XPLVVaja38PlvL+q9SlVfsllv5e2+p+u6ZXa
9zFCVT5cbf80NV2q4mH5H7X8sBq6Nn+ANd8vOx9VtT7XvR/Hqret8w97vfo3
VH0fq+YDqJ23zorTBZH+qOmk2nyGKmTnaVk8auvIULD0gXU9qnfx6cjQxNhS
Mz01/HLz7EzzZHR8+frCjM17obb/mBqPGtTGT1nl3etl+S4Wj4suqe3/4+J/
1PwhyqO2PqKt8Wf7H7ReNV1y0Z8qHhZc7ktNH9T2m2XxZPsfl36ci/60VU9c
6kWh5n+q8lcosv0Pej1bl1z0p4qHhbbeFwqXPLaaD4xQ5aNYuqSmPz1WoOYD
0XiydcN9fkUE1r4iVXknVJd6/amFu86g/O7j7y55rar8NuqXev1ZG3RNZ1hw
1wF3/5btryJd+g1XBXaO
     "], {{0, 0}, {49, 49}}, {0, 1}], Frame -> True, 
    FrameLabel -> {None, None}, FrameTicks -> {{{{48.5, 
         FormBox["\"0:0\"", TraditionalForm]}, {47.5, 
         FormBox["\"1:1\"", TraditionalForm]}, {46.5, 
         FormBox["\"2:2\"", TraditionalForm]}, {45.5, 
         FormBox["\"0:1\"", TraditionalForm]}, {44.5, 
         FormBox["\"1:0\"", TraditionalForm]}, {43.5, 
         FormBox["\"1:2\"", TraditionalForm]}, {42.5, 
         FormBox["\"2:1\"", TraditionalForm]}, {41.5, 
         FormBox["\"2:0\"", TraditionalForm]}, {40.5, 
         FormBox["\"0:2\"", TraditionalForm]}, {39.5, 
         FormBox["\"0:1,2\"", TraditionalForm]}, {38.5, 
         FormBox["\"1,2:0\"", TraditionalForm]}, {37.5, 
         FormBox["\"1:0,2\"", TraditionalForm]}, {36.5, 
         FormBox["\"0,2:1\"", TraditionalForm]}, {35.5, 
         FormBox["\"2:0,1\"", TraditionalForm]}, {34.5, 
         FormBox["\"0,1:2\"", TraditionalForm]}, {33.5, 
         FormBox["\"0:0,2\"", TraditionalForm]}, {32.5, 
         FormBox["\"0,2:0\"", TraditionalForm]}, {31.5, 
         FormBox["\"1:0,1\"", TraditionalForm]}, {30.5, 
         FormBox["\"0,1:1\"", TraditionalForm]}, {29.5, 
         FormBox["\"2:1,2\"", TraditionalForm]}, {28.5, 
         FormBox["\"1,2:2\"", TraditionalForm]}, {27.5, 
         FormBox["\"0:0,1\"", TraditionalForm]}, {26.5, 
         FormBox["\"0,1:0\"", TraditionalForm]}, {25.5, 
         FormBox["\"1:1,2\"", TraditionalForm]}, {24.5, 
         FormBox["\"1,2:1\"", TraditionalForm]}, {23.5, 
         FormBox["\"2:0,2\"", TraditionalForm]}, {22.5, 
         FormBox["\"0,2:2\"", TraditionalForm]}, {21.5, 
         FormBox["\"1,2:1,2\"", TraditionalForm]}, {20.5, 
         FormBox["\"0,2:0,2\"", TraditionalForm]}, {19.5, 
         FormBox["\"0,1:0,1\"", TraditionalForm]}, {18.5, 
         FormBox["\"1,2:0,2\"", TraditionalForm]}, {17.5, 
         FormBox["\"0,2:1,2\"", TraditionalForm]}, {16.5, 
         FormBox["\"0,2:0,1\"", TraditionalForm]}, {15.5, 
         FormBox["\"0,1:0,2\"", TraditionalForm]}, {14.5, 
         FormBox["\"0,1:1,2\"", TraditionalForm]}, {13.5, 
         FormBox["\"1,2:0,1\"", TraditionalForm]}, {12.5, 
         FormBox["\"0:0,1,2\"", TraditionalForm]}, {11.5, 
         FormBox["\"0,1,2:0\"", TraditionalForm]}, {10.5, 
         FormBox["\"1:0,1,2\"", TraditionalForm]}, {9.5, 
         FormBox["\"0,1,2:1\"", TraditionalForm]}, {8.5, 
         FormBox["\"2:0,1,2\"", TraditionalForm]}, {7.5, 
         FormBox["\"0,1,2:2\"", TraditionalForm]}, {6.5, 
         FormBox["\"1,2:0,1,2\"", TraditionalForm]}, {5.5, 
         FormBox["\"0,1,2:1,2\"", TraditionalForm]}, {4.5, 
         FormBox["\"0,2:0,1,2\"", TraditionalForm]}, {3.5, 
         FormBox["\"0,1,2:0,2\"", TraditionalForm]}, {2.5, 
         FormBox["\"0,1:0,1,2\"", TraditionalForm]}, {1.5, 
         FormBox["\"0,1,2:0,1\"", TraditionalForm]}, {0.5, 
         FormBox["\"0,1,2:0,1,2\"", TraditionalForm]}}, None}, {{{0.5, 
         FormBox[
          RotationBox["\"0:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {1.5, 
         FormBox[
          RotationBox["\"1:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {2.5, 
         FormBox[
          RotationBox["\"2:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {3.5, 
         FormBox[
          RotationBox["\"0:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {4.5, 
         FormBox[
          RotationBox["\"1:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {5.5, 
         FormBox[
          RotationBox["\"1:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {6.5, 
         FormBox[
          RotationBox["\"2:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {7.5, 
         FormBox[
          RotationBox["\"2:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {8.5, 
         FormBox[
          RotationBox["\"0:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {9.5, 
         FormBox[
          RotationBox["\"0:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {10.5, 
         FormBox[
          RotationBox["\"1,2:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {11.5, 
         FormBox[
          RotationBox["\"1:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {12.5, 
         FormBox[
          RotationBox["\"0,2:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {13.5, 
         FormBox[
          RotationBox["\"2:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {14.5, 
         FormBox[
          RotationBox["\"0,1:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {15.5, 
         FormBox[
          RotationBox["\"0:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {16.5, 
         FormBox[
          RotationBox["\"0,2:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {17.5, 
         FormBox[
          RotationBox["\"1:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {18.5, 
         FormBox[
          RotationBox["\"0,1:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {19.5, 
         FormBox[
          RotationBox["\"2:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {20.5, 
         FormBox[
          RotationBox["\"1,2:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {21.5, 
         FormBox[
          RotationBox["\"0:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {22.5, 
         FormBox[
          RotationBox["\"0,1:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {23.5, 
         FormBox[
          RotationBox["\"1:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {24.5, 
         FormBox[
          RotationBox["\"1,2:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {25.5, 
         FormBox[
          RotationBox["\"2:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {26.5, 
         FormBox[
          RotationBox["\"0,2:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {27.5, 
         FormBox[
          RotationBox["\"1,2:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {28.5, 
         FormBox[
          RotationBox["\"0,2:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {29.5, 
         FormBox[
          RotationBox["\"0,1:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {30.5, 
         FormBox[
          RotationBox["\"1,2:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {31.5, 
         FormBox[
          RotationBox["\"0,2:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {32.5, 
         FormBox[
          RotationBox["\"0,2:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {33.5, 
         FormBox[
          RotationBox["\"0,1:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {34.5, 
         FormBox[
          RotationBox["\"0,1:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {35.5, 
         FormBox[
          RotationBox["\"1,2:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {36.5, 
         FormBox[
          RotationBox["\"0:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {37.5, 
         FormBox[
          RotationBox["\"0,1,2:0\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {38.5, 
         FormBox[
          RotationBox["\"1:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {39.5, 
         FormBox[
          RotationBox["\"0,1,2:1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {40.5, 
         FormBox[
          RotationBox["\"2:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {41.5, 
         FormBox[
          RotationBox["\"0,1,2:2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {42.5, 
         FormBox[
          RotationBox["\"1,2:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {43.5, 
         FormBox[
          RotationBox["\"0,1,2:1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {44.5, 
         FormBox[
          RotationBox["\"0,2:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {45.5, 
         FormBox[
          RotationBox["\"0,1,2:0,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {46.5, 
         FormBox[
          RotationBox["\"0,1:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {47.5, 
         FormBox[
          RotationBox["\"0,1,2:0,1\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}, {48.5, 
         FormBox[
          RotationBox["\"0,1,2:0,1,2\"", BoxRotation -> 1.5707963267948966`], 
          TraditionalForm]}}, None}}, FrameTicksStyle -> 
    Directive[FontFamily -> "Consolas", 
      GrayLevel[0], 8], GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImageSize -> 490, 
    Method -> {
     "GridLinesInFront" -> True, "AxisPadding" -> Scaled[0.02], 
      "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05]}, PlotRangePadding -> None], 
   FormBox[
    FormBox[
     TemplateBox[{
       TemplateBox[{",", "\",\"", "0"}, "RowWithSeparators"], 
       TemplateBox[{",", "\",\"", "1"}, "RowWithSeparators"], 
       TemplateBox[{",", "\",\"", "2"}, "RowWithSeparators"], 
       TemplateBox[{",", "\",\"", "3"}, "RowWithSeparators"], 
       TemplateBox[{",", "\",\"", "4"}, "RowWithSeparators"]}, "SwatchLegend",
       DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.513417, 0.72992, 0.440682]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.705038, 0.742591, 0.299167]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.863512, 0.670771, 0.236564]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3, 
                   GraphicsBox[{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.902853, 0.453964, 0.192014]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4, 
                   GraphicsBox[{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.857359, 0.131106, 0.132128]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{1, 0.3}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0.5}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.513417, 0.72992, 0.440682]|>, 
                  "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.705038, 0.742591, 0.299167]|>, 
                  "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.863512, 0.670771, 0.236564]|>, 
                  "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.902853, 0.453964, 0.192014]|>, 
                  "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.857359, 0.131106, 0.132128]|>, 
                  "RGBColorSwatchTemplate"], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}, {
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {2, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Above"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9366055425838623`*^9, 3.9366055659217396`*^9}, 
   3.936605617369491*^9, {3.9366412872732463`*^9, 3.936641293333203*^9}, 
   3.9366413233751187`*^9, {3.9366413650500584`*^9, 3.936641410837777*^9}, 
   3.936641477813822*^9, 3.9366417459560833`*^9, {3.936641903589821*^9, 
   3.9366419244263144`*^9}, {3.9366419715114117`*^9, 
   3.9366420328333807`*^9}, {3.9366420874199543`*^9, 
   3.9366420943688426`*^9}, {3.936642465969205*^9, 3.936642487127967*^9}, 
   3.9366428123950386`*^9, {3.936642930345828*^9, 3.9366429424834185`*^9}, 
   3.936643248155658*^9, {3.9366433713149776`*^9, 3.936643428031191*^9}, 
   3.9366435889115887`*^9, 3.936643909388525*^9, 3.936643959393324*^9, 
   3.9366440857022448`*^9, {3.936644121006914*^9, 3.936644134980755*^9}, {
   3.9366442324209237`*^9, 3.9366442424815483`*^9}, 3.9366442929621325`*^9, {
   3.936644339669442*^9, 3.9366443555507717`*^9}, 3.9366444260702424`*^9, 
   3.936644510352931*^9, 3.936644584450965*^9, 3.9366446486434474`*^9, {
   3.9366451414864173`*^9, 3.9366451552873917`*^9}, 3.9366452554925284`*^9, 
   3.936645324850068*^9, 3.9366454498930063`*^9, 3.9366454862568145`*^9, 
   3.9366869194021254`*^9, 3.9366976768982573`*^9, {3.9366977128253593`*^9, 
   3.9366977368182373`*^9}, 3.9366977949177566`*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"41d9b94a-961d-4783-b605-63338434ebef"],

Cell[BoxData[
 StyleBox[
  TagBox[
   TagBox[GridBox[{
      {
       StyleBox["\[Null]",
        ShowStringCharacters->False], 
       TagBox[
        RotationBox["\<\"0:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:0\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"2:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"1,2:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,2:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:0,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:0,1\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm], 
       TagBox[
        RotationBox["\<\"0,1,2:0,1,2\"\>",
         BoxRotation->1.5707963267948966`],
        HoldForm]},
      {
       TagBox["\<\"0:0\"\>",
        HoldForm], 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>",
        "2", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "3", "3", "3", "3", "4"},
      {
       TagBox["\<\"1:1\"\>",
        HoldForm], "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "3",
        "3", "\<\"-\"\>", "\<\"-\"\>", "3", "3", "4"},
      {
       TagBox["\<\"2:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "1", "2",
        "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "3", "3", "3", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "4"},
      {
       TagBox["\<\"0:1\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", "3", "\<\"-\"\>", "3",
        "3", "4"},
      {
       TagBox["\<\"1:0\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\
\>", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "3", "3", "3", "4"},
      {
       TagBox["\<\"1:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\
\"\>", "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "3", "3", "\<\"-\"\>", "3", 
       "3", "\<\"-\"\>", "4"},
      {
       TagBox["\<\"2:1\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\
\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\
\>", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "3",
        "3", "3", "\<\"-\"\>", "\<\"-\"\>", "3", "4"},
      {
       TagBox["\<\"2:0\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\
\"\>", "\<\"-\"\>", "\<\"-\"\>", "0", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "3", "3", "\<\"-\"\>", "3", "4"},
      {
       TagBox["\<\"0:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\
\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "0", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2",
        "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "3", "3", "3", "3", "\<\"-\"\>", "4"},
      {
       TagBox["\<\"0:1,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "\<\"-\"\>", "2",
        "2", "\<\"-\"\>", "2", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"1,2:0\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "0", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "1", "3", "\<\"-\"\>", "3", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", "3"},
      {
       TagBox["\<\"1:0,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "0", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "2", "\<\"-\"\>", "\<\"-\"\>", "2",
        "2", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"0,2:1\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "0", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "1", "3", "\<\"-\"\>", "\<\"-\"\>", "2",
        "2", "\<\"-\"\>", "\<\"-\"\>", "2", "3"},
      {
       TagBox["\<\"2:0,1\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\
\"\>", "\<\"-\"\>", "1", "1", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2",
        "0", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "3", "1", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "3"},
      {
       TagBox["\<\"0,1:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\
\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "1", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "0", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "1", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "3", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"0:0,2\"\>",
        HoldForm], 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "0", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"0,2:0\"\>",
        HoldForm], 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2",
        "3"},
      {
       TagBox["\<\"1:0,1\"\>",
        HoldForm], "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "0", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "3", "1", "3", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "3"},
      {
       TagBox["\<\"0,1:1\"\>",
        HoldForm], "\<\"-\"\>", "1", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "2", "0", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "3", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "3"},
      {
       TagBox["\<\"2:1,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "0", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "3", "1", "3", "2", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"1,2:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "2", "0", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "1", "2", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"0:0,1\"\>",
        HoldForm], "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "0", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "3", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "2", "3"},
      {
       TagBox["\<\"0,1:0\"\>",
        HoldForm], "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "2", "2", "2", "3"},
      {
       TagBox["\<\"1:1,2\"\>",
        HoldForm], "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "0", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "3", "2", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"1,2:1\"\>",
        HoldForm], "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "0", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "3", "1", 
       "3", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2",
        "3"},
      {
       TagBox["\<\"2:0,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "0", 
       "2", "\<\"-\"\>", "1", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "3", "\<\"-\"\>", "\<\"-\"\>", "1", "3", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"0,2:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\
\>", "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "0", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", "1", "\<\"-\"\>", "2",
        "2", "2", "\<\"-\"\>", "\<\"-\"\>", "3"},
      {
       TagBox["\<\"1,2:1,2\"\>",
        HoldForm], "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "1", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", 
       "2", "2", "1", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>",
        "2"},
      {
       TagBox["\<\"0,2:0,2\"\>",
        HoldForm], "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "1", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "1", "1", "\<\"-\"\>", "\<\"-\"\>", "2"},
      {
       TagBox["\<\"0,1:0,1\"\>",
        HoldForm], "2", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "1", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "2", "2", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "1", "2"},
      {
       TagBox["\<\"1,2:0,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", "2", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "2"},
      {
       TagBox["\<\"0,2:1,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2"},
      {
       TagBox["\<\"0,2:0,1\"\>",
        HoldForm], "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2",
        "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "2"},
      {
       TagBox["\<\"0,1:0,2\"\>",
        HoldForm], "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", "\<\"-\"\>",
        "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "1", "\<\"-\"\>", 
       "2"},
      {
       TagBox["\<\"0,1:1,2\"\>",
        HoldForm], "\<\"-\"\>", "2", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "2"},
      {
       TagBox["\<\"1,2:0,1\"\>",
        HoldForm], "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", \
"\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "0", "\<\"-\"\>", "2", "2", "2", "2", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "2"},
      {
       TagBox["\<\"0:0,1,2\"\>",
        HoldForm], "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "1", 
       "3", "\<\"-\"\>", "3", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "2", "2", "2", "2", "\<\"-\"\>", "0", 
       "4", "\<\"-\"\>", "4", "\<\"-\"\>", "4", "\<\"-\"\>", "3", "1", "3", 
       "1", "3", "2"},
      {
       TagBox["\<\"0,1,2:0\"\>",
        HoldForm], "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "\<\"-\"\>", "2", "2",
        "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", "4", "0", 
       "4", "\<\"-\"\>", "4", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "1", "3", 
       "1", "2"},
      {
       TagBox["\<\"1:0,1,2\"\>",
        HoldForm], "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", "4", "0", 
       "4", "\<\"-\"\>", "4", "1", "3", "\<\"-\"\>", "3", "1", "3", "2"},
      {
       TagBox["\<\"0,1,2:1\"\>",
        HoldForm], "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", "1", "3", "\<\"-\"\>",
        "3", "\<\"-\"\>", "3", "1", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", "2", 
       "4", "\<\"-\"\>", "4", "0", "4", "\<\"-\"\>", "3", "1", 
       "3", "\<\"-\"\>", "3", "1", "2"},
      {
       TagBox["\<\"2:0,1,2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", "1", "3", "2", 
       "2", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "4", "\<\"-\"\>", "4", "0", "4", "1", "3", "1", 
       "3", "\<\"-\"\>", "3", "2"},
      {
       TagBox["\<\"0,1,2:2\"\>",
        HoldForm], "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "3", "\<\"-\"\>", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "1", "2", 
       "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", "2", "\<\"-\"\>", 
       "4", "\<\"-\"\>", "4", "\<\"-\"\>", "4", "0", "3", "1", "3", "1", 
       "3", "\<\"-\"\>", "2"},
      {
       TagBox["\<\"1,2:0,1,2\"\>",
        HoldForm], "\<\"-\"\>", "3", "3", "\<\"-\"\>", "3", "3", "3", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "3", "1", "3", "1", "3", "0", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "2", "1"},
      {
       TagBox["\<\"0,1,2:1,2\"\>",
        HoldForm], "\<\"-\"\>", "3", "3", "3", "\<\"-\"\>", "3", 
       "3", "\<\"-\"\>", "3", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>",
        "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "3", "\<\"-\"\>", "3",
        "1", "3", "1", "2", "0", "2", "\<\"-\"\>", "2", "\<\"-\"\>", "1"},
      {
       TagBox["\<\"0,2:0,1,2\"\>",
        HoldForm], "3", "\<\"-\"\>", "3", "3", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "3", "3", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "3", "\<\"-\"\>", "3",
        "1", "3", "\<\"-\"\>", "2", "0", "2", "\<\"-\"\>", "2", "1"},
      {
       TagBox["\<\"0,1,2:0,2\"\>",
        HoldForm], "3", "\<\"-\"\>", "3", "\<\"-\"\>", "3", "3", "\<\"-\"\>", 
       "3", "3", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "1", "\<\"-\"\>",
        "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "3", 
       "1", "3", "\<\"-\"\>", "3", "1", "2", "\<\"-\"\>", "2", "0", 
       "2", "\<\"-\"\>", "1"},
      {
       TagBox["\<\"0,1:0,1,2\"\>",
        HoldForm], "3", "3", "\<\"-\"\>", "3", "3", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "3", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "1", "1", "\<\"-\"\>", "1",
        "3", "1", "3", "\<\"-\"\>", "3", "\<\"-\"\>", "2", "\<\"-\"\>", "2", 
       "0", "2", "1"},
      {
       TagBox["\<\"0,1,2:0,1\"\>",
        HoldForm], "3", "3", "\<\"-\"\>", "3", "3", "\<\"-\"\>", "3", 
       "3", "\<\"-\"\>", "\<\"-\"\>", "2", "\<\"-\"\>", "2", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "2", "2", "2", "\<\"-\"\>", "\<\"-\"\>",
        "2", "2", "\<\"-\"\>", 
       "2", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
       "1", "\<\"-\"\>", "\<\"-\"\>", "1", "\<\"-\"\>", "\<\"-\"\>", "1", "3",
        "1", "3", "1", "3", "\<\"-\"\>", "2", "\<\"-\"\>", "2", "\<\"-\"\>", 
       "2", "0", "1"},
      {
       TagBox["\<\"0,1,2:0,1,2\"\>",
        HoldForm], "4", "4", "4", "4", "4", "4", "4", "4", "4", "3", "3", "3",
        "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", 
       "3", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", 
       "2", "2", "1", "1", "1", "1", "1", "1", "0"}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, 
       "Rows" -> {False, True, {False}, False}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, 
     TableHeadings -> {{
       "0:0", "1:1", "2:2", "0:1", "1:0", "1:2", "2:1", "2:0", "0:2", "0:1,2",
         "1,2:0", "1:0,2", "0,2:1", "2:0,1", "0,1:2", "0:0,2", "0,2:0", 
        "1:0,1", "0,1:1", "2:1,2", "1,2:2", "0:0,1", "0,1:0", "1:1,2", 
        "1,2:1", "2:0,2", "0,2:2", "1,2:1,2", "0,2:0,2", "0,1:0,1", "1,2:0,2",
         "0,2:1,2", "0,2:0,1", "0,1:0,2", "0,1:1,2", "1,2:0,1", "0:0,1,2", 
        "0,1,2:0", "1:0,1,2", "0,1,2:1", "2:0,1,2", "0,1,2:2", "1,2:0,1,2", 
        "0,1,2:1,2", "0,2:0,1,2", "0,1,2:0,2", "0,1:0,1,2", "0,1,2:0,1", 
        "0,1,2:0,1,2"}, {
        Rotate["0:0", 90 Degree], 
        Rotate["1:1", 90 Degree], 
        Rotate["2:2", 90 Degree], 
        Rotate["0:1", 90 Degree], 
        Rotate["1:0", 90 Degree], 
        Rotate["1:2", 90 Degree], 
        Rotate["2:1", 90 Degree], 
        Rotate["2:0", 90 Degree], 
        Rotate["0:2", 90 Degree], 
        Rotate["0:1,2", 90 Degree], 
        Rotate["1,2:0", 90 Degree], 
        Rotate["1:0,2", 90 Degree], 
        Rotate["0,2:1", 90 Degree], 
        Rotate["2:0,1", 90 Degree], 
        Rotate["0,1:2", 90 Degree], 
        Rotate["0:0,2", 90 Degree], 
        Rotate["0,2:0", 90 Degree], 
        Rotate["1:0,1", 90 Degree], 
        Rotate["0,1:1", 90 Degree], 
        Rotate["2:1,2", 90 Degree], 
        Rotate["1,2:2", 90 Degree], 
        Rotate["0:0,1", 90 Degree], 
        Rotate["0,1:0", 90 Degree], 
        Rotate["1:1,2", 90 Degree], 
        Rotate["1,2:1", 90 Degree], 
        Rotate["2:0,2", 90 Degree], 
        Rotate["0,2:2", 90 Degree], 
        Rotate["1,2:1,2", 90 Degree], 
        Rotate["0,2:0,2", 90 Degree], 
        Rotate["0,1:0,1", 90 Degree], 
        Rotate["1,2:0,2", 90 Degree], 
        Rotate["0,2:1,2", 90 Degree], 
        Rotate["0,2:0,1", 90 Degree], 
        Rotate["0,1:0,2", 90 Degree], 
        Rotate["0,1:1,2", 90 Degree], 
        Rotate["1,2:0,1", 90 Degree], 
        Rotate["0:0,1,2", 90 Degree], 
        Rotate["0,1,2:0", 90 Degree], 
        Rotate["1:0,1,2", 90 Degree], 
        Rotate["0,1,2:1", 90 Degree], 
        Rotate["2:0,1,2", 90 Degree], 
        Rotate["0,1,2:2", 90 Degree], 
        Rotate["1,2:0,1,2", 90 Degree], 
        Rotate["0,1,2:1,2", 90 Degree], 
        Rotate["0,2:0,1,2", 90 Degree], 
        Rotate["0,1,2:0,2", 90 Degree], 
        Rotate["0,1:0,1,2", 90 Degree], 
        Rotate["0,1,2:0,1", 90 Degree], 
        Rotate["0,1,2:0,1,2", 90 Degree]}}]]],
  StripOnInput->False,
  LineColor->GrayLevel[0],
  FrontFaceColor->GrayLevel[0],
  BackFaceColor->GrayLevel[0],
  GraphicsColor->GrayLevel[0],
  FontSize->8,
  FontColor->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.9366055425838623`*^9, 3.9366055659217396`*^9}, 
   3.936605617369491*^9, {3.9366412872732463`*^9, 3.936641293333203*^9}, 
   3.9366413233751187`*^9, {3.9366413650500584`*^9, 3.936641410837777*^9}, 
   3.936641477813822*^9, 3.9366417459560833`*^9, {3.936641903589821*^9, 
   3.9366419244263144`*^9}, {3.9366419715114117`*^9, 
   3.9366420328333807`*^9}, {3.9366420874199543`*^9, 
   3.9366420943688426`*^9}, {3.936642465969205*^9, 3.936642487127967*^9}, 
   3.9366428123950386`*^9, {3.936642930345828*^9, 3.9366429424834185`*^9}, 
   3.936643248155658*^9, {3.9366433713149776`*^9, 3.936643428031191*^9}, 
   3.9366435889115887`*^9, 3.936643909388525*^9, 3.936643959393324*^9, 
   3.9366440857022448`*^9, {3.936644121006914*^9, 3.936644134980755*^9}, {
   3.9366442324209237`*^9, 3.9366442424815483`*^9}, 3.9366442929621325`*^9, {
   3.936644339669442*^9, 3.9366443555507717`*^9}, 3.9366444260702424`*^9, 
   3.936644510352931*^9, 3.936644584450965*^9, 3.9366446486434474`*^9, {
   3.9366451414864173`*^9, 3.9366451552873917`*^9}, 3.9366452554925284`*^9, 
   3.936645324850068*^9, 3.9366454498930063`*^9, 3.9366454862568145`*^9, 
   3.9366869194021254`*^9, 3.9366976768982573`*^9, {3.9366977128253593`*^9, 
   3.9366977368182373`*^9}, 3.936697794957405*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"34b4bfeb-b5af-45f4-9557-5a3d0acd1658"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"class", "<>", "\"\< motions order plot.pdf\>\""}], ",", "plot"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"class", "<>", "\"\< motions order table.pdf\>\""}], ",", 
   "table"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9366446577791805`*^9, 3.9366446924607697`*^9}, {
  3.9366447540437174`*^9, 3.936644764468071*^9}, {3.936697850653417*^9, 
  3.9366978634786367`*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"503699bf-967f-4a8e-ae51-c7c07ca8c79d"],

Cell[BoxData["\<\"S3B2 motions order plot.pdf\"\>"], "Output",
 CellChangeTimes->{3.9366446970955334`*^9, 3.9366447689682674`*^9, 
  3.936645506282531*^9, 3.9366978674433837`*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"69fd0bc2-bee0-4ed7-abf8-df5939ca0db6"],

Cell[BoxData["\<\"S3B2 motions order table.pdf\"\>"], "Output",
 CellChangeTimes->{3.9366446970955334`*^9, 3.9366447689682674`*^9, 
  3.936645506282531*^9, 3.936697867728258*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"812ea91f-1355-4df9-804d-c0958fad04a7"]
}, Open  ]]
},
WindowSize->{586.875, 598.875},
WindowMargins->{{Automatic, 241.875}, {25.875, Automatic}},
Magnification:>1. Inherited,
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7d6b655e-d399-4e80-9e07-eb780c996756"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 20055, 499, 2091, "Input",ExpressionUUID->"74b5ceff-56d8-40b3-b4d0-cbb72a96ec14"],
Cell[20638, 523, 20529, 420, 536, "Output",ExpressionUUID->"41d9b94a-961d-4783-b605-63338434ebef"],
Cell[41170, 945, 39587, 839, 573, "Output",ExpressionUUID->"34b4bfeb-b5af-45f4-9557-5a3d0acd1658"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80794, 1789, 555, 13, 47, "Input",ExpressionUUID->"503699bf-967f-4a8e-ae51-c7c07ca8c79d"],
Cell[81352, 1804, 262, 4, 32, "Output",ExpressionUUID->"69fd0bc2-bee0-4ed7-abf8-df5939ca0db6"],
Cell[81617, 1810, 261, 4, 32, "Output",ExpressionUUID->"812ea91f-1355-4df9-804d-c0958fad04a7"]
}, Open  ]]
}
]
*)

